/*@@@**************************************************************************
 * \file  displayStateParam
 * \author Hernan Badino
 * \date  Mon Apr 27 13:54:26 EDT 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include "displayStateParam.h"
#include "stringOp.h"
#include "displayStateParamEditor.h"

using namespace VIC;

CDisplayStateParameter::CDisplayStateParameter ( std::string               f_name_str, 
                                                 std::string               f_comment_str,
                                                 SDisplayState             f_displayState,
                                                 CParameterBaseConnector * f_connector_p )
        : CParameter ( f_name_str, f_comment_str, f_connector_p ),
          m_displayState (                       f_displayState )
{
    /// update string value.
    CParameter::updateInitialValue();
    update();
}

CDisplayStateParameter::~CDisplayStateParameter()
{}

std::string
CDisplayStateParameter::getStringFromValue ( ) const
{
    char str[32];
    sprintf(str,
            "%i,%i,%i", 
            m_displayState.position.x, 
            m_displayState.position.y, 
            m_displayState.visible_b );

    return std::string(str);
}

bool
CDisplayStateParameter::setValueFromString ( std::string f_val_str )
{
    int fields_i;
    int x_i, y_i, visible_i;

    fields_i = sscanf(f_val_str.c_str(), "%i,%i,%i",
                      &x_i, 
                      &y_i, 
                      &visible_i );

    if (fields_i != 3)
        return false;

    m_displayState.position.x = x_i;    
    m_displayState.position.y = y_i;
    m_displayState.visible_b = visible_i;

    updateInitialValue();
    return update();
}

SDisplayState
CDisplayStateParameter::getValue ( ) const
{
    return m_displayState;
}

bool
CDisplayStateParameter::setValue ( SDisplayState f_displayState,
                                   bool          f_shouldUpdate_b )
{
    if ( f_displayState == m_displayState )
        return true;

    m_displayState = f_displayState;
    
    if ( f_shouldUpdate_b )
        return update();
    return true;
    
}

::QWidget *
CDisplayStateParameter::createEditor ( )
{
    return  (m_qtEditor_p = new CDisplayStateParameterEditor ( this ));
}

/* ////////////  Version History ///////////////
 *  $Log: displayStateParam.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:14  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
