/*@@@**************************************************************************
 * \file  stringParamEditor
 * \author Hernan Badino
 * \date  Mon Apr 27 16:05:38 EDT 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include "dbl2DParamEditor.h"

#include <QLabel>
#include <QGridLayout>

#include "doubleEditor.h"

using namespace VIC;

const unsigned int CDbl2DParameterEditor::m_maxDecimals_cui = 6;

CDbl2DParameterEditor::CDbl2DParameterEditor( CDbl2DParameter *  f_parameter_p,
                                              QWidget *          f_parent_p )
        : CBaseParamEditorWidget ( f_parent_p ),
          m_parameter_p (       f_parameter_p )
{
    QSizePolicy sizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);

    QGridLayout *layout_p = new QGridLayout( this );    
    layout_p -> setMargin( 0 );    

    const std::string * names_p = f_parameter_p -> getNames();
    
    unsigned int pos_i = 0;
    
    /// Sping boxes now.
    for (int i = 0; i < 2; ++i)
    {
        m_qdsb_p[i] = new CDoubleEditor ( 0, this );
        m_qdsb_p[i] -> setDecimals ( m_maxDecimals_cui );
        sizePolicy.setHeightForWidth(m_qdsb_p[i]->sizePolicy().hasHeightForWidth());
        m_qdsb_p[i] -> setSizePolicy ( sizePolicy );

        if (not names_p[i].empty() )
        {    
            layout_p -> addWidget(new QLabel( names_p[i].c_str(), this ), 0, pos_i++, 1, 1 );
        }

        layout_p -> addWidget( m_qdsb_p[i], 0, pos_i++, 1, 1 );
    }

    updateWidget();

    connect( m_qdsb_p[0],  SIGNAL( valueChanged ( double ) ),
             this,        SLOT(   updateParameter() ) );

    connect( m_qdsb_p[1],  SIGNAL( valueChanged ( double ) ),
             this,        SLOT(   updateParameter() ) );
}

CDbl2DParameterEditor::~CDbl2DParameterEditor ()
{}

void
CDbl2DParameterEditor::updateParameter()
{
    S2D<double> value( m_qdsb_p[0]->getValue(),
                       m_qdsb_p[1]->getValue() );

    if ( not (m_parameter_p -> getValue() == value ) )
        m_parameter_p -> setValue( value );
}

bool
CDbl2DParameterEditor::updateWidget()
{
    S2D<double> value = m_parameter_p -> getValue();
    
    m_qdsb_p[0] -> setValue(value.x);
    m_qdsb_p[1] -> setValue(value.y);
    
    return true;    
}


/* ////////////  Version History ///////////////
 *  $Log: dbl2DParamEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
