/*@@@**************************************************************************
* \file  boolParamEditor
* \author Hernan Badino
* \date  Mon Apr 27 16:05:38 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "boolParamEditor.h"

#include <QCheckBox>
#include <QHBoxLayout>

using namespace VIC;

CBoolParameterEditor::CBoolParameterEditor( CBoolParameter *  f_parameter_p,
                                            QWidget        *  f_parent_p )
        : CBaseParamEditorWidget ( f_parent_p ),
          m_qcb_p (                      NULL ),
          m_parameter_p (       f_parameter_p )
{
    m_qcb_p = new QCheckBox( this );

    m_qcb_p -> setCheckState ( f_parameter_p -> getValue()?Qt::Checked:Qt::Unchecked );

    QHBoxLayout *layout_p = new QHBoxLayout( this );

    layout_p -> setMargin( 0 );    
    layout_p -> addWidget( m_qcb_p );
    
    if ( not f_parameter_p ->getComment().empty() )
        m_qcb_p -> setToolTip ( QString(f_parameter_p ->getComment().c_str() ) );
    
    connect( m_qcb_p,   SIGNAL( toggled(     bool ) ),
             this,      SLOT(   updateParameter() ) );
}

CBoolParameterEditor::~CBoolParameterEditor ()
{}

void
CBoolParameterEditor::updateParameter()
{
    if ( m_parameter_p -> getValue() != m_qcb_p -> isChecked() )
    {
        m_parameter_p -> setValue( m_qcb_p -> isChecked() );
    }
}

bool
CBoolParameterEditor::updateWidget()
{
    if ( m_parameter_p -> getValue() != m_qcb_p -> isChecked() )
        m_qcb_p -> setCheckState ( m_parameter_p -> getValue()?Qt::Checked:Qt::Unchecked );

    return true;
}


/* ////////////  Version History ///////////////
 *  $Log: boolParamEditor.cpp,v $
 *  Revision 1.2  2009/11/18 15:50:15  badino
 *  badino: global changes.
 *
 *//////////////////////////////////////////////
