/*@@@**************************************************************************
 * \file  3DVectorParamEditor.cpp
 * \author Hernan Badino
 * \date  Mon Apr 27 16:05:38 EDT 2009
 * \notes 
 *******************************************************************************
 ******************************************************************************/

/* INCLUDES */
#include "3DVectorParamEditor.h"

#include <QLabel>
#include <QGridLayout>

#include "doubleEditor.h"

using namespace VIC;

const unsigned int C3DVectorParamEditor::m_maxDecimals_cui = 6;

C3DVectorParamEditor::C3DVectorParamEditor( C3DVectorParameter *  f_parameter_p,
                                            QWidget *          f_parent_p )
        : CBaseParamEditorWidget ( f_parent_p ),
          m_parameter_p (       f_parameter_p )
{
    QSizePolicy sizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);

    QGridLayout *layout_p = new QGridLayout( this );    
    layout_p -> setMargin( 0 );    

    const std::string * names_p = f_parameter_p -> getNames();
    
    unsigned int pos_i = 0;
    
    /// Sping boxes now.
    for (int i = 0; i < 3; ++i)
    {
        m_qdsb_p[i] = new CDoubleEditor ( 0, this );
        m_qdsb_p[i] -> setDecimals ( m_maxDecimals_cui );
        sizePolicy.setHeightForWidth(m_qdsb_p[i]->sizePolicy().hasHeightForWidth());
        m_qdsb_p[i] -> setSizePolicy ( sizePolicy );

        if (not names_p[i].empty() )
        {    
            layout_p -> addWidget(new QLabel( names_p[i].c_str(), this ), 0, pos_i++, 1, 1 );
        }

        layout_p -> addWidget( m_qdsb_p[i], 0, pos_i++, 1, 1 );
    }

    updateWidget();

    connect( m_qdsb_p[0],  SIGNAL( valueChanged ( double ) ),
             this,        SLOT(   updateParameter() ) );

    connect( m_qdsb_p[1],  SIGNAL( valueChanged ( double ) ),
             this,        SLOT(   updateParameter() ) );

    connect( m_qdsb_p[2],  SIGNAL( valueChanged ( double ) ),
             this,        SLOT(   updateParameter() ) );
}

C3DVectorParamEditor::~C3DVectorParamEditor ()
{}

void
C3DVectorParamEditor::updateParameter()
{
    C3DVector value( m_qdsb_p[0]->getValue(),
                     m_qdsb_p[1]->getValue(),
                     m_qdsb_p[2]->getValue() );

    if ( not (m_parameter_p -> getValue() == value ) )
        m_parameter_p -> setValue( value );
}

bool
C3DVectorParamEditor::updateWidget()
{
    C3DVector value = m_parameter_p -> getValue();
    
    m_qdsb_p[0] -> setValue(value.x());
    m_qdsb_p[1] -> setValue(value.y());
    m_qdsb_p[2] -> setValue(value.z());

    return true;    
}


/* ////////////  Version History ///////////////
 *  $Log: 3DVectorParamEditor.cpp,v $
 *  Revision 1.1  2010/01/18 17:12:29  badino
 *  General updates and added new classes.
 *
 *//////////////////////////////////////////////
