/*@@@**************************************************************************
 * \file  3DVectorParam.cpp
 * \author Hernan Badino
 * \date  Mon Apr 27 13:54:26 EDT 2009
 * \notes 
 *******************************************************************************
 *****     (C) COPYRIGHT Hernan Badino                                     *****
 ******************************************************************************/

/* INCLUDES */
#include <limits>
#include "3DVectorParam.h"
#include "3DVectorParamEditor.h"
#include "stringOp.h"

using namespace VIC;

C3DVectorParameter::C3DVectorParameter ( std::string               f_name_str, 
                                         std::string               f_comment_str,
                                         C3DVector                 f_value,
                                         std::string               f_name1_str,
                                         std::string               f_name2_str,
                                         std::string               f_name3_str,
                                         CParameterBaseConnector * f_connector_p )
        : CParameter ( f_name_str, f_comment_str, f_connector_p ),
          m_value (                       f_value )
{
    m_names_p[0] = f_name1_str;
    m_names_p[1] = f_name2_str;
    m_names_p[2] = f_name3_str;

    /// update string value.
    CParameter::updateInitialValue();
    update();
}

C3DVectorParameter::~C3DVectorParameter()
{}

std::string
C3DVectorParameter::getStringFromValue ( ) const
{
    std::string str1 = CStringOp::numToString<double> ( m_value.at(0),  0, std::numeric_limits<float>::digits );
    std::string str2 = CStringOp::numToString<double> ( m_value.at(1),  0, std::numeric_limits<float>::digits );
    std::string str3 = CStringOp::numToString<double> ( m_value.at(2),  0, std::numeric_limits<float>::digits );

    str1 += ",";
    str1 += str2;
    str1 += ",";
    str1 += str3;

    return str1;
}

bool
C3DVectorParameter::setValueFromString ( std::string f_val_str )
{
    int fields_i;
    double x_d, y_d, z_d;

    fields_i = sscanf(f_val_str.c_str(), "%lf,%lf,%lf",
                      &x_d, 
                      &y_d,
                      &z_d );

    if (fields_i != 3)
        return false;

    m_value.set( x_d, y_d, z_d);

    updateInitialValue();
    return update();
}

C3DVector
C3DVectorParameter::getValue ( ) const
{
    return m_value;
}

bool
C3DVectorParameter::setValue ( C3DVector   f_value,
                               bool        f_shouldUpdate_b )
{
    if ( f_value == m_value )
        return true;

    m_value = f_value;

    if ( f_shouldUpdate_b )
        return update();
    return true;
}

::QWidget *
C3DVectorParameter::createEditor ( )
{
    return  (m_qtEditor_p = new C3DVectorParamEditor ( this ));
}

/* ////////////  Version History ///////////////
 *  $Log: 3DVectorParam.cpp,v $
 *  Revision 1.1  2010/01/18 17:12:29  badino
 *  General updates and added new classes.
 *
 *//////////////////////////////////////////////
