#ifndef __VELODYNESTREAM_H
#define __VELODYNESTREAM_H

/**
 *******************************************************************************
 *
 * @file velodyneStream.h
 *
 * \class SVelodynePointData
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Data structure to store velodyne measurements.
 *
 * The structure defines a time stamp, range, azimuth and elevation components.
 * The measurement components are also available with the vector elem_p.
 *
 *******************************************************************************/

/* INCLUDES */
#include "ioObj.h"
#include <vector>

/* CONSTANTS */

namespace VIC
{
    class SVelodynePointData//: public CIOObj
    {
    public:
        /// Time stamp in seconds since epoch.
        double timeStamp_d;

        union
        {
            struct
            {
                /// Range in meters
                double range_d;
                
                /// Azimuth in radians.
                double azimuth_d;
                
                /// Elevation in radians.
                double elevation_d;
            };
            
            double elem_p[3];
        };
    };


/**
 * @file velodyneStream.h
 *
 * \class CVelodyneDataStream
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Defines a vector of SVelodynePointData elements.
 *
 */

    class CVelodyneDataStream: public CIOObj, public std::vector<SVelodynePointData>
    {};

}

#endif // __VELODYNESTREAM_H

/* ////////////  Version History ///////////////
 *  $Log: velodyneStream.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
