#ifndef __UINTPARAMEDITOR_H
#define __UINTPARAMEDITOR_H

/**
 *******************************************************************************
 *
 * @file uintParamEditor.h
 *
 * \class CUIntParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for  an object of type CUIntParameter.
 *
 * The class implements a simple Qt editor with an input box where
 * the user enters an unsigned int value.
 *
 *******************************************************************************/

/* INCLUDES */
#include "baseParamEditorWidget.h"
#include "uintParam.h"

/* PROTOTYPES */

namespace VIC
{
    /* PROTOTYPES */
    class CUIntEditor;

    class CUIntParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
    public:
        
        /// Constructors/Destructor
        CUIntParameterEditor ( CUIntParameter *  f_parameter_p,
                              QWidget        *  f_parent_p = NULL );

        virtual ~CUIntParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

    /// Protected members
    protected:

        /// Stored value.
        CUIntEditor *           m_editor_p;

        /// Associated UInt parameter
        CUIntParameter *        m_parameter_p;
    };
}

#endif // __UINTPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: uintParamEditor.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
