#ifndef __UINTPARAM_H
#define __UINTPARAM_H

/**
 *******************************************************************************
 *
 * @file uintParam.h
 *
 * \class CUIntParameter
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Parameter interface for a unsigned int variable.
 *
 * The class implements a parameter interface for a unsigned int variable.
 *
 *******************************************************************************/

/* INCLUDES */
#include "parameter.h"

namespace VIC
{
    /* PROTOTYPES */

    class CUIntParameter : public CParameter
    {
    public:
        
        /// Constructors/Destructor
        CUIntParameter (  std::string                f_name_str = "",
                          std::string                f_comment_str = "",
                          unsigned int               f_value_ui = 0,
                          CParameterBaseConnector *  f_connector_p = NULL );

        virtual ~CUIntParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set uint value
        virtual unsigned int    getValue ( ) const;
        virtual bool            setValue ( unsigned int f_value_b,
                                           bool         f_shouldUpdate_b = true );


        /// Get editor.
        virtual QWidget *       createEditor ( );

    /// Protected members
    protected:

        /// Stored value.
        unsigned int      m_val_ui;
    };
}


#endif // __UINTPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: uintParam.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
