#ifndef __UINTEDITOR_H
#define __UINTEDITOR_H

/**
 *******************************************************************************
 *
 * @file uintEditor.h
 *
 * \class CUIntEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CUIntParameter.
 *
 * The class implements a simple Qt editor with one input box where
 * the user enters a unsigned integer value.
 *
 *******************************************************************************/

/* INCLUDES */
#include <QWidget>

/* PROTOTYPES */
class QLineEdit;

namespace VIC
{
    /* PROTOTYPES */

    class CUIntEditor : public QWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        CUIntEditor ( unsigned int   f_value_ui,
                      QWidget *      f_parent_p = NULL );
        
        virtual ~CUIntEditor ();

        unsigned int getValue() const { return m_value_ui; }
        
        bool   setValue( unsigned int f_value_ui );
        
        virtual QSize sizeHint () const;

    protected slots:
        void lineEditChanged();

    signals:
        void valueChanged( unsigned int );
        
        /// Protected members
    protected:

        /// Stored value.
        QLineEdit *          m_qle_p;

        /// Unsigned int value
        unsigned int         m_value_ui;
    };
}

#endif // __UINTEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: uintEditor.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
