#ifndef __UINT2DPARAMEDITOR_H
#define __UINT2DPARAMEDITOR_H

/**
 *******************************************************************************
 *
 * @file uint2DParamEditor.h
 *
 * \class CUInt2DParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CUInt2DParameter.
 *
 * The class implements a simple Qt editor with two input boxes where
 * the user enters unsigned integer values.
 *
 *******************************************************************************/

/* INCLUDES */
#include "baseParamEditorWidget.h"

#include "uint2DParam.h"

/* PROTOTYPES */

namespace VIC
{
    /* PROTOTYPES */
    class CUIntEditor;

    class CUInt2DParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        CUInt2DParameterEditor ( CUInt2DParameter *  f_parameter_p,
                                 QWidget *          f_parent_p = NULL );

        virtual ~CUInt2DParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

        /// Protected members
    protected:

        /// Stored value.
        CUIntEditor *      m_qsb_p[2];

        /// Associated Int2D parameter
        CUInt2DParameter * m_parameter_p;
    };
}

#endif // __UINT2DPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: uint2DParamEditor.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
