#ifndef __UINT2DPARAM_H
#define __UINT2DPARAM_H

/**
 *******************************************************************************
 *
 * @file uint2DParam.h
 *
 * \class CUInt2DParameter
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Parameter interface for a S2D<unsigned int> variable.
 *
 * The class implements a parameter interface for a S2D<unsigned int> variable.
 *
 *******************************************************************************/

/* INCLUDES */
#include "parameter.h"
#include "standardTypes.h"

namespace VIC
{
    /* PROTOTYPES */

    class CUInt2DParameter : public CParameter
    {
    public:
        
        /// Constructors/Destructor
        CUInt2DParameter (  std::string               f_name_str = "",
                            std::string               f_comment_str = "",
                            S2D<unsigned int>         f_val = S2D<unsigned int>(0,0),
                            std::string               f_name1_str = "",
                            std::string               f_name2_str = "",
                            CParameterBaseConnector * f_connector_p = NULL );
        
        virtual ~CUInt2DParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set Int2D value
        virtual S2D<unsigned int> getValue ( ) const;
        virtual bool              setValue ( S2D<unsigned int> f_value,
                                             bool              f_shouldUpdate_b = true );
        
        const std::string *     getNames ( ) const 
        {
            return m_names_p;
        }

        /// Get editor.
        virtual QWidget *       createEditor ( );

    /// Protected members
    protected:

        /// Stored value.
        S2D<unsigned int>  m_value;

        /// Stored value.
        std::string  m_names_p[2];
    };
}


#endif // __UINT2DPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: uint2DParam.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
