#ifndef __UINT16IMAGE_H
#define __UINT16IMAGE_H

/**
 *******************************************************************************
 *
 * @file uShortImage.h
 *
 * \class CUShortImage
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Template class CTypedImage instantiated with <short unsigned int>.
 *
 * The class is a type definition of CTypedImage<uint16_t>.
 *
 ******************************************************************************/

/* INCLUDES */
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<uint16_t>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(uint16_t) );
        setDataType( IDT_USHORT );
        setImageFormat( CImageBase::IF_LUMINANCE );
    }

    typedef CTypedImage<uint16_t> CUShortImage;
}



#endif // __UINT16IMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: uShortImage.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
