#ifndef __UINT32IMAGE_H
#define __UINT32IMAGE_H

/**
 *******************************************************************************
 *
 * @file uIntImage.h
 *
 * \class CUIntImage
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Template class CTypedImage instantiated with <unsigned int>.
 *
 * The class is a type definition of CTypedImage<uint32_t>.
 *
 *******************************************************************************/

/* INCLUDES */
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<uint32_t>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(uint32_t) );
        setDataType( IDT_UINT );
        setImageFormat( CImageBase::IF_LUMINANCE );
    }

    typedef CTypedImage<uint32_t> CUIntImage;
}



#endif // __UINT32IMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: uIntImage.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
