#ifndef __UINT8IMAGE_H
#define __UINT8IMAGE_H

/**
 *******************************************************************************
 *
 * @file uByteImage.h
 *
 * \class CUByteImage
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Template class CTypedImage instantiated with <unsigned char>.
 *
 * The class is a type definition of CTypedImage<uint8_t>.
 *
 *******************************************************************************/

/* INCLUDES */
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<uint8_t>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(uint8_t) );
        setDataType( IDT_UBYTE );
        setImageFormat( CImageBase::IF_LUMINANCE );
    }

    typedef CTypedImage<uint8_t> CUByteImage;
}



#endif // __UINT8IMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: uByteImage.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
