#ifndef __STRINGPARAMEDITOR_H
#define __STRINGPARAMEDITOR_H

/**
 *******************************************************************************
 *
 * @file stringParamEditor.h
 *
 * \class CStringParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CStringParameter.
 *
 * The class implements a simple Qt editor with an input box where
 * the user enters a string.
 *
 *******************************************************************************/

/* INCLUDES */
#include "baseParamEditorWidget.h"

#include "stringParam.h"

/* PROTOTYPES */
class QLineEdit;

namespace VIC
{
    /* PROTOTYPES */

    class CStringParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
    public:
        
        /// Constructors/Destructor
        CStringParameterEditor ( CStringParameter *  f_parameter_p,
                                 QWidget        *  f_parent_p = NULL );

        virtual ~CStringParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

    /// Protected members
    protected:

        /// Stored value.
        QLineEdit *               m_qle_p;

        /// Associated String parameter
        CStringParameter *        m_parameter_p;
    };
}

#endif // __STRINGPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: stringParamEditor.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
