#ifndef __STRINGPARAM_H
#define __STRINGPARAM_H

/**
 *******************************************************************************
 *
 * @file stringParam.h
 *
 * \class CStringParameter
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Parameter interface for a std::string variable.
 *
 * The class implements a parameter interface for a std::string variable.
 *
 *******************************************************************************/

/* INCLUDES */
#include "parameter.h"

namespace VIC
{
    /* PROTOTYPES */

    class CStringParameter : public CParameter
    {
    public:
        
        /// Constructors/Destructor
        CStringParameter (  std::string               f_name_str = "",
                            std::string               f_comment_str = "",
                            std::string               f_value_str = false,
                            CParameterBaseConnector * f_connector_p = NULL );

        virtual ~CStringParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set string value
        virtual std::string     getValue ( ) const;
        virtual bool            setValue ( std::string f_value_str,
                                           bool        f_shouldUpdate_b = true );


        /// Get editor.
        virtual QWidget *       createEditor ( );

    /// Protected members
    protected:

        /// Stored value.
        std::string             m_str;
    };
}


#endif // __STRINGPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: stringParam.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
