#ifndef __STRINGOP_H
#define __STRINGOP_H

/**
 *******************************************************************************
 *
 * @file stringOp.h
 *
 * \class CStringOp
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements a series of static methods for handling strings.
 *
 * Implements a series of static methods for handling strings, such as
 * triming and number to string conversion.
 *
 *
 *******************************************************************************/

/* INCLUDES */
#include <iostream>
#include <ios>
#include <string>
#include <sstream>

namespace VIC
{
    class CStringOp
    {
        /// Constructors / Destructor.
    public:
        CStringOp ( );
        virtual ~CStringOp ( );

    public:
        static bool trimLeft  ( std::string &str );
        static bool trimRight ( std::string &str );
        static bool trim      ( std::string &str );

        template <class Type>
        static std::string numToString( const Type&             f_value, 
                                        int                     f_width_i = 0, 
                                        int                     f_precision_i = 0, 
                                        std::ios_base::fmtflags f_flags = (std::ios_base::fmtflags)0, 
                                        char                    f_fillchar_c = 0 );
    };

    typedef CStringOp strOp;

    template <class Type> std::string 
    CStringOp::numToString( const Type&             f_value, 
                            int                     f_width_i, 
                            int                     f_precision_i, 
                            std::ios_base::fmtflags f_flags, 
                            char                    f_fillchar_c )
    {
        std::ostringstream ss;
        if (f_width_i > 0) ss.width( f_width_i );
        if (f_precision_i > 0) ss.precision( f_precision_i );
        if (f_flags != 0) ss.flags( f_flags );
        if (f_fillchar_c != 0) ss.fill( f_fillchar_c );

        ss << f_value;

        return ss.str();
    }
}

#endif // __STRINGOPS_H

/* ////////////  Version History ///////////////
 *  $Log: stringOp.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
