#ifndef __SRIHOLESFILLER_H
#define __SRIHOLESFILLER_H

/**
 *******************************************************************************
 *
 * @file sriHolesFiller.h
 *
 * \class CSriHolesFiller
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an operator for filling holes in spherical range images.
 *
 * The class implements an operator for filling holes in a spherical range image.
 * It fills first holes with a left and right neighbors and then empty lines by
 * interpolating the two neighboring lines.
 *
 *
 *******************************************************************************/

/* INCLUDES */
#include "paramMacros.h"
#include "sphericalRangeImage.h"

/* CONSTANTS */

namespace VIC
{
    class CSriHolesFiller
    {
    /// Constructors/Destructor
    public:
        CSriHolesFiller();
        virtual ~CSriHolesFiller();
        
    /// Operate
    public:
        /// Fill Holes.
        virtual bool     fillHoles ( CSphericalRangeImage &fr_sri,
                                     const bool            f_fillVertEmptyLines_b = true);

        /// Fill Holes.
        virtual bool     addParameters ( CParameterSet &f_paramSet );

    /// Sets/Gets
    public:
        ADD_PARAM_ACCESS (bool,         m_fillHoles_b,          FillHoles );
        ADD_PARAM_ACCESS (unsigned int, m_maxImgDistance_ui,    MaxImgDistance );
        ADD_PARAM_ACCESS (double,       m_minRangeProportion_d, MinRangeProportion );
        ADD_PARAM_ACCESS (unsigned int, m_minHoles_ui,          MinHoles );
        
    protected:

        /// Holes counter.
        short unsigned int *    m_holesCount_p;

        /// Holes counter.
        unsigned int            m_vectorSize_ui;
        
        /// Should fill holes?
        bool                    m_fillHoles_b;

        /// Max distance of neighbors to fill holes.
        unsigned int            m_maxImgDistance_ui;

        /// Min range proportion to fill holes.
        double                  m_minRangeProportion_d;

        /// Min holes in line to assume .
        unsigned int            m_minHoles_ui;
    };
}



#endif // __SRIHOLESFILLER_H

/* ////////////  Version History ///////////////
 *  $Log: sriHolesFiller.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
