#ifndef __SPHPOINTVECTOR_H
#define __SPHPOINTVECTOR_H

/**
 *******************************************************************************
 *
 * @file sphericalDataVector.h
 *
 * \class SSphericalPointData
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Data structure to store points in spherical coordinates.
 *
 * The structure defines a range, azimuth and elevation components.
 * The measurement components are also available with the vector elem_p.
 *
 *******************************************************************************/

/* INCLUDES */
#include <vector>

/* CONSTANTS */

namespace VIC
{
    class SSphericalPointData: public CIOObj
    {
    public:
        union
        {
            struct
            {
                /// Azimuth in radians.
                double azimuth_d;
                
                /// Elevation in radians.
                double elevation_d;

                /// Range in meters
                double range_d;                
            };
            
            double elem_p[3];
        };
    };

/**
 * @file velodyneStream.h
 *
 * \class CSphericalDataVector
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Defines a vector of SSphericalPointData elements.
 *
 */

    class CSphericalDataVector: public CIOObj, public std::vector<SSphericalPointData>
    {};
}

#endif // __SPHPOINTVECTOR_H

/* ////////////  Version History ///////////////
 *  $Log: sphericalDataVector.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
