#ifndef __INT16IMAGE_H
#define __INT16IMAGE_H

/**
 *******************************************************************************
 *
 * @file shortImage.h
 *
 * \class CShortImage
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Template class CTypedImage instantiated with <short int>.
 *
 * The class is a type definition of CTypedImage<int16_t>.
 *
 *******************************************************************************/

/* INCLUDES */
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<int16_t>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(int16_t) );
        setDataType( IDT_SHORT );
        setImageFormat( CImageBase::IF_LUMINANCE );
    }

    typedef CTypedImage<int16_t> CShortImage;
}



#endif // __INT16IMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: shortImage.h,v $
 *  Revision 1.3  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *  Revision 1.2  2009/10/13 19:52:26  badino
 *  badino: added documentation.
 *
 *//////////////////////////////////////////////
