#ifndef __SEQDEVICECONTROL_H
#define __SEQDEVICECONTROL_H

/**
 *******************************************************************************
 *
 * @file sriHolesFiller.h
 *
 * \class CSriHolesFiller
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an operator for filling holes in spherical range images.
 *
 * The class implements an operator for filling holes in a spherical range image.
 * It fills first holes with a left and right neighbors and then empty lines by
 * interpolating the two neighboring lines.
 *
 *
 *******************************************************************************/

/* INCLUDES */
#include <map>
#include <vector>
#include <QObject>

/* CONSTANTS */

/* PROTOTYPES */
class QDialog;


namespace VIC
{
    /* PROTOTYPES */
    class CIOObj;

    class CSeqDeviceControl: public QObject
    {
        Q_OBJECT

    /// Public data types
    public:
        typedef enum 
        {
            S_PLAYING = -1,
            S_PAUSED,
            S_PLAYING_BACKWARD
        } EState_t;         

    /// Constructors, Destructors
    public:
        /// Constructor
        CSeqDeviceControl()
                : m_currentState_e (     S_PAUSED ) {  }

        /// Destructor
        virtual ~CSeqDeviceControl() {};

    /// Sequence Handling.
    public:
        /// Initialize Device.
        virtual bool     initialize() = 0;

        /// Load next frame
        virtual bool     nextFrame() = 0;

        /// Load previous frame
        virtual bool     prevFrame() = 0;

        /// Load next frame
        virtual bool     goToFrame( int f_frameNumber_i ) = 0;

        /// Stop/Stand
        virtual bool     stop() = 0;

         /// Play
        virtual bool     startPlaying() = 0;

         /// Play Backwards
        virtual bool     startPlayingBackward() = 0;

         /// Pause
        virtual bool     pause() = 0;

        /// Load next frame
        virtual bool     goToFirstFrame() { return goToFrame(1); }

        /// Load next frame
        virtual bool     goToLastFrame() { return goToFrame(getNumberOfFrames()); }

    /// Get/Set 
    public slots:
        
        /// Get the number of frames in the sequence.
        virtual int      getNumberOfFrames() const = 0;

        /// Get current frame in the sequence.
        virtual int      getCurrentFrame() const = 0;

        /// Is a forward/backward device?
        virtual bool     isBidirectional() const = 0;

        /// Get the state of the device.
        virtual EState_t getState() const { return m_currentState_e; }

        /// Get the dialogs of this device.
        virtual std::vector<QDialog *> 
                         getDialogs ( ) const
        { 
            std::vector<QDialog *> diag_v;
            return diag_v;
        }

    /// Load next frame
    public:
        virtual bool     registerOutputs ( 
                std::map< std::string, CIOObj* > & /*fr_map*/) { return false; }

    /// Virtual signals
    signals:
        virtual void     start();
        virtual void     cycle();
        virtual void     reset();
        

    /// Protected members
    protected:
        /// State
        EState_t         m_currentState_e;

    /// Private members
    private:
        void dummy() { emit cycle(); emit reset(); }
        

    };
}

#endif // __SEQDEVICECONTROL_H

/* ////////////  Version History ///////////////
 *  $Log: seqDeviceControl.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
