#ifndef __SEQDEVTESTERDLG_H
#define __SEQDEVTESTERDLG_H

/**
 *******************************************************************************
 *
 * @file seqDevTesterDlg.h
 *
 * \class CSeqDevTesterDlg
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Class emulating the dialog of a virtual device for testing purposes.
 *
 *******************************************************************************/

/* INCLUDES */
#include <QDialog>
#include "ui_seqDevTesterDlg.h"

/* CONSTANTS */

namespace VIC
{
    class CSeqDevTesterDlg: public QDialog, private Ui::CSeqDevTesterDlgDesign
    {
        Q_OBJECT
        
    public:
        CSeqDevTesterDlg ( QWidget *f_parent_p = 0 ); 
        virtual ~CSeqDevTesterDlg() {}

    /// Gets and Sets
    public:
        int  getNumberOfFrames() const { int temp = m_qsbNOF_p -> value(); printf("temp = %i\n", temp); return temp;}
        bool isBidirectional()  const { return m_qcbBidirectional_p -> isChecked(); }
        int  getNumberOfImagesPerFrame() const { return m_qsbNumOfImgsPerFrame_p -> value(); }
        bool isEnabled()  const { return m_qcbEnabled_p -> isChecked(); }

    /// Automatic Signal/Slot connections.
    public slots:
        /// Begin Clicked.
        void on_m_qpbReset_p_clicked() { printf("emiting reset\n"); emit reset(); }

    signals:
        void reset();

    private:

    };
}

#endif // __SEQDEVTESTERDLG_H

/* ////////////  Version History ///////////////
 *  $Log: seqDevTesterDlg.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
