#ifndef __SEQDEVTESTER_H
#define __SEQDEVTESTER_H

/**
 *******************************************************************************
 *
 * @file seqDevTester.h
 *
 * \class CSeqDevTester
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Class emulating a virtual device for testing purposes.
 *
 *******************************************************************************/

/* INCLUDES */
#include "seqDeviceControl.h"
#include "ioObj.h"
#include <vector>
#include <map>
#include <QObject>

/* CONSTANTS */

/* PROTOTYPES */
class QTimer;


namespace VIC
{
    /* PROTOTYPES */
    class CSeqDevTesterDlg;

    class CSeqDevTester: public CSeqDeviceControl
    {
        Q_OBJECT

        /// Constructors, Destructors
    public:
        /// Constructor
        CSeqDevTester();

        /// Destructor
        virtual ~CSeqDevTester() {}

    public slots:
         /// Get current frame in the sequence.
        virtual void timeOut();
       
        /// Stop and emit reset.
        virtual void stopAndEmitReset();
        
    /// Sequence Handling.
    public:
        /// Load next frame
        virtual bool nextFrame();

        /// Load previous frame
        virtual bool prevFrame();

        /// Load next frame
        virtual bool goToFrame( int f_frameNumber_i );

        /// Stop/Stand
        virtual bool stop();

         /// Play
        virtual bool startPlaying();

         /// Play Backwards
        virtual bool startPlayingBackward();

         /// Pause
        virtual bool pause();

    /// Get/Set 
    public:
        
        ///
        virtual int getNumberOfFrames() const;
 
        /// Get current frame in the sequence.
        virtual int getCurrentFrame() const;

        /// Is a forward/backward device?
        virtual bool isBidirectional() const;

        /// Get the dialogs of this device.
        virtual std::vector<QDialog *> getDialogs ( ) const;
        
    /// Load next frame
    public:
        virtual bool registerOutputs ( 
                std::map< std::string, CIOObj* > &fr_map );

    /// Virtual signals
    signals:
        //virtual void cycle();
        void reset();

    /// Protected members
    private:
        CSeqDevTesterDlg *            m_dialog_p;

    private:
        /// Timer for handling play actions.
        QTimer *                      m_qtPlay_p;

        /// Current frame
        int                           m_currentFrame_i;

        /// Backward play.
        bool                          m_backward_b;

        /// Buffer of output objects
        CIO_float                     m_output_p[100];
    };
}

#endif // __SEQDEVICECTRLHD_H

/* ////////////  Version History ///////////////
 *  $Log: seqDevTester.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
