#ifndef __SEQCONTROLER_H
#define __SEQCONTROLER_H

/**
 *******************************************************************************
 *
 * @file seqControler.h
 *
 * \class CSeqControler
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Interface class between the sequence control dialog and a device.
 *
 * Class acting as an interface between the sequence control dialog and
 * the device being used providing sequence information.
 *
 *******************************************************************************/

/* INCLUDES */
#include <QWidget>

/* CONSTANTS */

/* PROTOTYPES */

namespace VIC
{
/* PROTOTYPES */
    class CSeqControlDlg;
    class CSeqDeviceControl;    

    class CSeqControler: public QObject
    {
    /// Do I need to declare Q_OBJECT here?
        Q_OBJECT

    /// Constructors, Destructors
    public:
        /// Constructor
        CSeqControler( CSeqDeviceControl *f_device_p );

        /// Destructor
        virtual ~CSeqControler();

        
    /// Get Methods.
    public:

    /// Sequence Handling.
    public slots:

        void start();

        void stopClicked();
        void playClicked();
        void playBackwardClicked();
        void pauseClicked();
        void previousClicked();
        void nextClicked();
        void beginClicked();
        void endClicked();

        void reset();
        void goTo ( int f_frameNumber_i );

        void playCycle();

        //void startControler();

    /// Signals
    signals:
        void cycle();
        void stop();
        void initialize();
        void exit();

    /// Get/Set Methods.
    public:
        QDialog * getDialog() const;
        
    /// Private slots
    protected slots:

    /// Private methods.
    private:
        void refreshControlDlg();
        
    /// Protected members
    protected:

        /// Dialog control.
        CSeqControlDlg *        m_controlDlg_p;

        /// Dialog control.
        CSeqDeviceControl *     m_deviceCtrl_p;
    };
}


#endif // __SEQCONTROLER_H

/* ////////////  Version History ///////////////
 *  $Log: seqControler.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
