#ifndef __RGBAIMAGE_H
#define __RGBAIMAGE_H

/**
 *******************************************************************************
 *
 * @file rgbaImage.h
 *
 * \class CRgbaImage
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Template class CTypedImage instantiated with <SRgba>.
 *
 * The class is a type definition of CTypedImage<SRgba>.
 *
 ******************************************************************************/

/* INCLUDES */
#include "typedImage.h"
#include "colors.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<SRgba>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(SRgba) );
        setDataType( IDT_BYTE );
        setImageFormat( CImageBase::IF_RGBA );
    }

    typedef CTypedImage<SRgba> CRgbaImage;
}



#endif // __RGBAIMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: rgbaImage.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
