#ifndef __RGBIMAGE_H
#define __RGBIMAGE_H

/**
 *******************************************************************************
 *
 * @file rgbaImage.h
 *
 * \class CRgbImage
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Template class CTypedImage instantiated with <SRgb>.
 *
 * The class is a type definition of CTypedImage<SRgb>.
 *
 ******************************************************************************/

/* INCLUDES */
#include "typedImage.h"
#include "colors.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<SRgb>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(SRgb) );
        setDataType( GL_BYTE );
        setImageFormat( CImageBase::IF_RGB );
    }

    typedef CTypedImage<int32_t> CRgbImage;
}



#endif // __RGBIMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: rgbImage.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
