#ifndef __RECTLIST_H
#define __RECTLIST_H

/**
 *******************************************************************************
 *
 * @file rectList.h
 *
 * \class CRectangleList
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Handles a list of rectangles for displaying in screen or writing in file.
 *
 * The class is derived from CDrawingElementList implementing a list of rectangles.
 * Rectangles are composed of: 
 *  - rows and columns of the top-left and bottom-right corners.
 *  - an outline color, 
 *  - a fill color, and 
 *  - a line width.
 *
 ******************************************************************************/

/* INCLUDES */
#include "drawingElementList.h"
#include "colors.h"

#include <vector>

/* CONSTANTS */


namespace VIC
{
    class CRectangleList: public CDrawingElementList
    {
        /// Constructor, Destructor
    public:
        /// Constructor
        CRectangleList( int f_bufferSize_i = -1);

        /// Destructor.
        virtual ~CRectangleList();

        /// Operations.
    public:

        // Add drawing from other list.
        virtual bool add (  const CRectangleList &f_otherList );

        // Add empty rectangles.
        virtual bool add (  float   f_u1_f, 
                            float   f_v1_f,
                            float   f_u2_f,
                            float   f_v2_f,
                            SRgba   f_color,
                            float   f_lineWidth_i );

        // Add filled rectangles.
        virtual bool add (  float   f_u1_f, 
                            float   f_v1_f,
                            float   f_u2_f,
                            float   f_v2_f,
                            SRgba   f_outLineColor,
                            SRgba   f_fillColor,
                            float   f_lineWidth_i );

        // Is blendable.
        virtual bool isBlendable () { return true; }

        // Clear all rects.
        virtual bool clear ();

        // Draw all rects.
        virtual bool show () const;

        // Write rect in a SVG file.
        virtual bool write ( FILE*                f_file_p,
                             const float          f_offsetU_f = 0.0,
                             const float          f_offsetV_f = 0.0,
                             const std::string    f_parameters_str = "") const;

        // Return number of elements.
        virtual int  getSize () const;

    protected:
        typedef struct
        {
            /// Color information
            SRgba          outlineColor;

            /// Color information
            SRgba          fillColor;

            /// Start position.
            float          u1_f, v1_f;

            /// End position.
            float          u2_f, v2_f;

            /// Line width
            float          lineWidth_f;
        } SRectangle;

        /// Private Members
    private:
        std::vector<SRectangle>    m_rect_v;
    };
} // Namespace VIC


#endif // __RECTLIST_H

/* ////////////  Version History ///////////////
 *  $Log: rectList.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
