#ifndef __PREWITTFILTER_H
#define __PREWITTFILTER_H

/**
 *******************************************************************************
 *
 * @file prewittFilter.h
 *
 * \class CPrewittFilter
 * \date  Tue, 10 Nov
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Class for computing prewitt on images.
 *
 * The class implements an prewitt filter for arbitrary mask sizes.
 *
 ******************************************************************************/

/* INCLUDES */
/* INCLUDES */
#include "ioObj.h"
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    ///
    template <class _SrcType, class _DstType>
    class CPrewittFilter: public CIOObj
    {
    /// Some public enumerators.
    public:
        static bool computeVertical ( const CTypedImage<_SrcType> &f_srcImg,
                                      CTypedImage<_DstType>       &fr_dstImg,
                                      const S2D<unsigned int>     f_maskSize,
                                      const double              f_norm_d   = 1 );

        static bool computeHorizontal ( const CTypedImage<_SrcType> &f_srcImg,
                                        CTypedImage<_DstType>       &fr_dstImg,
                                        const S2D<unsigned int>     f_maskSize,
                                        const double              f_norm_d   = 1 );

        static bool computeVertical ( const CTypedImage<_SrcType> &f_srcImg,
                                      CTypedImage<_DstType>       &fr_dstImg,
                                      CTypedImage<_DstType>       &fr_buffer,
                                      const S2D<unsigned int>     f_maskSize,
                                      const _DstType              f_norm_d   = 1 );

        static bool computeHorizontal ( const CTypedImage<_SrcType> &f_srcImg,
                                        CTypedImage<_DstType>       &fr_dstImg,
                                        CTypedImage<_DstType>       &fr_buffer,
                                        const S2D<unsigned int>     f_maskSize,
                                        const _DstType              f_norm_d   = 1 );

        static bool computeVerticalIPP ( const CTypedImage<_SrcType> &f_srcImg,
                                         CTypedImage<_DstType>       &fr_dstImg,
                                         CTypedImage<_DstType>       &fr_buffer,
                                         const S2D<unsigned int>     f_maskSize,
                                         const _DstType              f_norm_d   = 1 );

    private:
        static bool computeVertical3x3 ( const CTypedImage<_SrcType> &f_srcImg,
                                         CTypedImage<_DstType>       &fr_dstImg,
                                         CTypedImage<_DstType>       &fr_buffer,
                                         const _DstType              f_norm_d );

        static bool computeHorizontal3x3 ( const CTypedImage<_SrcType> &f_srcImg,
                                           CTypedImage<_DstType>       &fr_dstImg,
                                           CTypedImage<_DstType>       &fr_buffer,
                                           const _DstType              f_norm_d );

        static bool computeVertical3x3 (   const CTypedImage<_SrcType> &f_srcImg,
                                           CTypedImage<_DstType>       &fr_dstImg,
                                           const double                f_norm_d   = 1 );

        static bool computeHorizontal3x3 ( const CTypedImage<_SrcType> &f_srcImg,
                                           CTypedImage<_DstType>       &fr_dstImg,
                                           const double                f_norm_d   = 1 );

        static bool computeVertical5x5   ( const CTypedImage<_SrcType> &f_srcImg,
                                           CTypedImage<_DstType>       &fr_dstImg,
                                           const double                f_norm_d   = 1 );

        static bool computeHorizontal5x5 ( const CTypedImage<_SrcType> &f_srcImg,
                                           CTypedImage<_DstType>       &fr_dstImg,
                                           const double                f_norm_d   = 1 );

        static bool computeVertical7x7   ( const CTypedImage<_SrcType> &f_srcImg,
                                           CTypedImage<_DstType>       &fr_dstImg,
                                           const double                f_norm_d   = 1 );

        static bool computeHorizontal7x7 ( const CTypedImage<_SrcType> &f_srcImg,
                                           CTypedImage<_DstType>       &fr_dstImg,
                                           const double                f_norm_d   = 1 );

        static bool computeVertical9x9   ( const CTypedImage<_SrcType> &f_srcImg,
                                           CTypedImage<_DstType>       &fr_dstImg,
                                           const double                f_norm_d   = 1 );

        static bool computeHorizontal9x9 ( const CTypedImage<_SrcType> &f_srcImg,
                                           CTypedImage<_DstType>       &fr_dstImg,
                                           const double                f_norm_d   = 1 );
    };
    
    #include "prewittFilter_inline.h"
}

#endif // __PREWITTFILTER_H
