#ifndef __PARAMTREEITEMMODEL_H
#define __PARAMTREEITEMMODEL_H

/**
 *******************************************************************************
 *
 * @file paramTreeItemModel.h
 *
 * \class CParamTreeItemModel
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Concrete interface class derived form QAbstractItemModel for handling
 * trees of parameter sets.
 *
 ******************************************************************************/

/* INCLUDES */

#include <QAbstractItemModel>
#include <QModelIndex>
#include <QVariant>

/* CONSTANTS */


namespace VIC
{

/* PROTOTYPES */
    class CParameterSet;

    class CParamTreeItemModel: public  QAbstractItemModel
    {
        Q_OBJECT
        
        public:
        CParamTreeItemModel ( CParameterSet *  f_rootNode_p,
                              QObject *        f_parent_p = 0 );

        ~CParamTreeItemModel ();
        
        QVariant      data ( const QModelIndex &f_index_i, 
                             int                f_role_i) const;

        Qt::ItemFlags flags ( const QModelIndex &f_index) const;
        
        QVariant      headerData ( int              f_section_i, 
                                   Qt::Orientation  f_orientation_e,
                                   int              f_role_i = Qt::DisplayRole) const;        
        QModelIndex   index ( int f_row_i, 
                              int f_column_i,
                              const QModelIndex &f_parent = QModelIndex()) const;
        
        QModelIndex   parent ( const QModelIndex &f_index_i) const;
        
        int           rowCount    ( const QModelIndex 
                                    &f_parent = QModelIndex() ) const;
        
        int           columnCount ( const QModelIndex 
                                    &f_parent = QModelIndex() ) const;
        
        bool          setData ( const QModelIndex &f_index, 
                                const QVariant    &f_value, 
                                int                f_role_i ); 

    protected:

    private:
        
        CParameterSet *          m_rootNode_p;
    };
}


#endif // __PARAMTREEITEMMODEL_H

/* ////////////  Version History ///////////////
 *  $Log: paramTreeItemModel.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
