#ifndef __PARAMIOHANDLING_H
#define __PARAMIOHANDLING_H

/**
 *******************************************************************************
 *
 * @file paramIOHandling.h
 *
 * \class CParamIOHandling
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Abstract class for handling input/output of parameters.
 *
 * Concrete child classes must implement the get and set functions.
 *
 ******************************************************************************/

/* INCLUDES */
#include <string>

/* CONSTANTS */

namespace VIC
{
    class CParamIOHandling
    {
    /// Destructor.
    public:
        virtual ~CParamIOHandling () {}
        
    /// Read and save
    public:
        
        /// Read parameter.
        virtual bool get ( std::string  f_paramName_str,
                           std::string  f_category_str,
                           std::string &fr_value_str,
                           std::string &fr_comment_str ) const = 0;

        /// Save parameter
        virtual bool set ( std::string  f_paramName_str,
                           std::string  f_category_str,
                           std::string  fr_value_str,
                           std::string  fr_comment_str ) = 0;
        
        /// Read parameter in current category.
        virtual bool get ( std::string  f_paramName_str,
                           std::string &fr_value_str ) const = 0;

        /// Read parameter in current category.
        virtual bool get ( std::string  f_paramName_str,
                           std::string &fr_value_str,
                           std::string &fr_comment_str ) const = 0;
        
        /// Save parameter in current category.
        virtual bool set ( std::string  f_paramName_str,
                           std::string  fr_value_str,
                           std::string  fr_comment_str = std::string("") ) = 0;

        /// Set the current category.
        virtual bool setCurrentCategory ( std::string  f_category_str );

        /// Save the current category.
        virtual std::string getCurrentCategory (  ) const;

    /// Private members.
    private:
        /// Current Category.
        std::string        m_currentCategory_str;
    };
    
    /// Set the current category.
    inline bool 
    CParamIOHandling::setCurrentCategory ( std::string  f_category_str )
    {
        m_currentCategory_str = f_category_str;
        return true;
    }

    /// Save the current category.
    inline std::string
    CParamIOHandling::getCurrentCategory ( ) const
    {
        return m_currentCategory_str;
    }
}

    /// Constructor/Destructor

#endif // __PARAMIOHANDLING_H

/* ////////////  Version History ///////////////
 *  $Log: paramIOHandling.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
