#ifndef __PARAMIOFILE_H
#define __PARAMIOFILE_H

/**
 *******************************************************************************
 *
 * @file paramIOFile.h.
 *
 * \class CParamIOFile
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Concrete class for handling input/output of parameters from
 * files.
 *
 ******************************************************************************/

/* INCLUDES */
#include"paramIOHandling.h"

#include <QXmlStreamReader>
#include <map>

/* CONSTANTS */

namespace VIC
{
    class CParamIOFile : public CParamIOHandling
    {
    /// Constructors / Destructor.
    public:
        CParamIOFile( std::string f_filePath_str = "" );
        virtual ~CParamIOFile( );

    public:
        /// Load file.
        bool        load ( std::string f_filePath_str );

        /// Save file.
        bool        save ( std::string f_filePath_str = "" );        

    public:
        /// Read parameter.
        virtual bool get ( std::string  f_paramName_str,
                           std::string  f_category_str,
                           std::string &fr_value_str,
                           std::string &fr_comment_str ) const;

        /// Save parameter
        virtual bool set ( std::string  f_paramName_str,
                           std::string  f_category_str,
                           std::string  fr_value_str,
                           std::string  fr_comment_str );
        
        /// Read parameter in current category.
        virtual bool get ( std::string  f_paramName_str,
                           std::string &fr_value_str ) const;

        /// Read parameter in current category.
        virtual bool get ( std::string  f_paramName_str,
                           std::string &fr_value_str,
                           std::string &fr_comment_str ) const;
        
        /// Save parameter in current category.
        virtual bool set ( std::string  f_paramName_str,
                           std::string  fr_value_str,
                           std::string  fr_comment_str = std::string("") );

    public:
        /// Set the current category.
        virtual bool setCurrentCategory ( std::string  f_category_str );

    /// Protected members.
    protected:
        
        struct ParamState_t
        {
            std::string value_str;
            std::string comment_str;
        };

        typedef std::map<std::string, ParamState_t> ParamMap_t;
        typedef std::map<std::string, ParamMap_t>   CategoryMap_t;

    /// Help methods.
    private:
        /// Read xml file.
        bool readVicParXml( QXmlStreamReader & fr_qxsReader );

        /// Read category.
        bool readCategory( QXmlStreamReader & fr_qxsReader,
                           ParamMap_t       & fr_paramMap );

        /// Read parameter.
        bool readParameter( QXmlStreamReader & fr_qxsReader,
                            ParamState_t     & fr_state );
        

    protected:

        /// Path to file.
        std::string              m_filePath_str;
        
        /// Map of parameters.
        CategoryMap_t            m_map;
        
    };
}


#endif // __PARAMIOFILE_H

/* ////////////  Version History ///////////////
 *  $Log: paramIOFile.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
