#ifndef __PARAMETERGROUP_H
#define __PARAMETERGROUP_H

/**
 *******************************************************************************
 *
 * @file paramGroup.h
 *
 * \class CParameterGroup
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Virtual parameter for defining the beginning of a display group.
 *
 ******************************************************************************/

/* INCLUDES */
#include "parameter.h"
#include "colors.h"

/* CONSTANTS */

/* PROTOTYPES */

namespace VIC
{
    class CParameterGroup: public CParameter
    {
    /// Constructors/Destructor
    public:
        CParameterGroup (  std::string   f_name_str,
                           bool          f_applyColor_b = false,
                           SRgb          f_color = CColor::white );

        
        virtual ~CParameterGroup ( );
        
    public:
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        void setColor ( SRgb f_newColor ) { m_color = f_newColor;  }
        SRgb getColor ( ) const { return m_color; }
        
        bool applyColor (  ) const {  return m_applyColor_b; }
        void setApplyColor ( bool f_apply_b ) { m_applyColor_b = f_apply_b; }


    /// Protected help methods.
    protected:

        /// Use background color?
        bool    m_applyColor_b;

        /// Background color;
        SRgb    m_color;
   };
}


#endif // __PARAMETERGROUP_H

/* ////////////  Version History ///////////////
 *  $Log: paramGroup.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
