#ifndef __PARAMEDITORDLG_H
#define __PARAMEDITORDLG_H

/**
 *******************************************************************************
 *
 * @file paramEditorDlg.h
 *
 * \class CParameterEditorDlg
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Class implementing the dialog where parameters are shown and can be
 * edited. 
 *
 * The dialog is composed of three parts. The top/left sections shows
 * a tree structure with the parameter sets. The top/right section show the actual
 * parameters for the active parameter set in the top/left section. The lower 
 * section has some buttons for storing and reading parameters from files.
 *
 ******************************************************************************/

/* INCLUDES */
#include <QDialog>
#include <QModelIndex>
/* CONSTANTS */

/* PROTOTYPES */
class QGLWidget;
class QSplitter;
class QTreeView;
class QFrame;
class QSplitter;

namespace VIC
{

/* PROTOTYPES */
    class CParameterSet;
    //class CDisplayOpNode;

/* CLASS DEFINITION */

    class CParameterEditorDlg: public QDialog
    {
        Q_OBJECT
        
        public:
        CParameterEditorDlg (  CParameterSet *  f_rootNode_p,
                               QWidget *        f_parent_p );
        ~CParameterEditorDlg ();
        
    /// Protected slots
    protected slots:

        void reloadParameterPage ( const QModelIndex & f_index  );
        void save ( );
        void load ( );

    /// Protected help methods.
    protected:
        void parameterPageExited();
        
        
    private:

        /// Root node.
        CParameterSet *                   m_rootNode_p;

        /// Root node.
        CParameterSet *                   m_currentPage_p;

        /// Splitter to separate categorie tree from parameters.
        QSplitter *                       m_splitter_p;
        
        /// Display tree view for categories.
        QTreeView *                       m_qtvCategory_p;

        /// Display tree view for categories.
        QFrame *                          m_qfParamPage_p;

    };
}


#endif // __PARAMEDITORDLG_H

/* ////////////  Version History ///////////////
 *  $Log: paramEditorDlg.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
