#ifndef __MOVINGSUMFILTER_H
#define __MOVINGSUMFILTER_H

/**
 *******************************************************************************
 *
 * @file movingSumFilter.h
 *
 * \class CMovingSumFilter
 * \date  Tue, 10 Nov
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Class for computing sum within a window.
 *
 * The class implements a moving sum filter for arbitrary mask sizes.
 *
 ******************************************************************************/

/* INCLUDES */
/* INCLUDES */
#include "ioObj.h"
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    ///
    template <class _SrcType, class _DstType>
    class CMovingSumFilter: public CIOObj
    {
    /// Some public enumerators.
    public:
        bool compute ( const CTypedImage<_SrcType> &f_srcImg,
                       CTypedImage<_DstType>       &fr_dstImg,
                       const S2D<unsigned int>     f_maskSize,
                       const double                f_norm_d   = 1 );
    /// Some 
    private:
        
    };
    
    #include "movingSumFilter_inline.h"
}

#endif // __MOVINGSUMFILTER_H
