#ifndef __MEDFILTER_H
#define __MEDFILTER_H

/**
 *******************************************************************************
 *
 * @file medFilter.h
 *
 * \class CMedianFilter
 * \date  Tue, 10 Nov
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Class for computing median filter on images.
 *
 * The class implements an median filter for squared masks of fixed size.
 *
 ******************************************************************************/

/* INCLUDES */
#include "ioObj.h"
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    ///
    template <class _SrcType, class _DstType>
    class CMedianFilter: public CIOObj
    {
    /// Some public enumerators.
    public:
        static bool compute3x3 ( const CTypedImage<_SrcType> &f_srcImg,
                                 CTypedImage<_DstType>       &fr_dstImg );


        static bool compute5x5 ( const CTypedImage<_SrcType> &f_srcImg,
                                 CTypedImage<_DstType>       &fr_dstImg );
    };
    
    #include "medianFilter_inline.h"
}

#endif // __MEDFILTER_H
