#ifndef __MAINWINDOW_H
#define __MAINWINDOW_H

/**
 *******************************************************************************
 *
 * @file mainWindow.h
 *
 * \class CMainWindow
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief The class implements the main window dialog of the framework.
 *
 * The CMainWindow class instantiates the device controls, parameter editors, 
 * displays dialogs and control dialogs. It also acts as communication interface 
 * between all those components. A pointer to the root operator must be given 
 * in the instantiation of the object.
 *
 *******************************************************************************/

/* INCLUDES */
#include <QMainWindow>
#include "events.h"

/* CONSTANTS */

/* PROTOTYPES */

namespace VIC
{
/* NAMESPACE PROTOTYPES */
    class CSeqDeviceControl;
    class CSeqControler;
    class CDisplayWidget;
    class COperator;
    class CWindowListView;
    class CParameterEditorDlg;
    class CGLViewer;

    class CMainWindow: public QMainWindow
    {
        Q_OBJECT

    public:
        
        CMainWindow ( COperator * f_rootOp_p );
        virtual ~CMainWindow();
        
    public slots:
        /// Hide all windows.
        virtual void hideAllWindows();

        /// Show all windows.
        virtual void showAllWindows();

        /// Show about dialog.
        virtual void about();

        /// Cycle
        virtual void initialize();

        /// Cycle
        virtual void cycle();

        /// Stop
        virtual void stop();

        /// Key Pressed event.
        virtual void keyPressed     ( CKeyEvent * f_event_p );
        virtual void mousePressed   ( CMouseEvent *  f_event_p );
        virtual void mouseReleased  ( CMouseEvent *  f_event_p );
        virtual void mouseMoved     ( CMouseEvent *  f_event_p );
        virtual void wheelTurned    ( CWheelEvent *  f_event_p );        
        virtual void regionSelected ( CRegionSelectedEvent * 
                                      f_event_p );

    //// Protected signals.
    protected:
        void closeEvent ( QCloseEvent *  f_event_p);
        
    //// Private methods.
    private:
        
        /// Create Menues.
        void createMenues();

        /// Create Menues.
        void createBaseWidgets();

    private:

        /// Vector of windows.
        CWindowListView *         m_listView_p;

        /// Control Window.
        //VIC::CSeqControlDlg *      m_control_p;

        /// Input device.
        CSeqDeviceControl *       m_device_p;

        /// Control Window.
        CSeqControler *           m_controler_p;

        /// Display widget.
        CDisplayWidget *          m_display_p;

        /// Display widget.
        CParameterEditorDlg *     m_paramEditorDlg_p;

        /// Display widget.
        COperator *               m_rootOp_p;

        /// 3D Viewer
#if defined HAVE_QGLVIEWER
        CGLViewer *               m_3dViewer_p;
#endif
  
    };
}

#endif // __MAINWINDOW_H

/* ////////////  Version History ///////////////
 *  $Log: mainWindow.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
