#ifndef __LOGGER_H
#define __LOGGER_H

/**
 *******************************************************************************
 *
 * @file logger.h
 *
 * \class CLogger
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Class for handling message logs of the framework.
 *
 *******************************************************************************/

/* INCLUDES */
#include <string>
#include <iostream>

/* CONSTANTS */

    /* SOME MACROS */
#define WARN(a) std::cout << "Warning in " <<  __FILE__ << " at line " << __LINE__ << ": " << a << std::endl
    
    
    // Shows "a" as a string followed by " = " and its value.
    // Example: if w=2 showval(w) prints "w = 2"
    // also, if q = 3.0 then showval(w*w/q); shows "w*w/q = 1.3333"
    // Usefull to debug and print parameters. Hernan.
#define SHOWVAL(a) { std::cout << #a " = " << a << "\n"; }


namespace VIC
{
    class CLogger
    {
    /// Constructor, Desctructors
    public:
        
        /// Constructors.
        CLogger () {};
        
        /// Virtual destructor.
        virtual ~CLogger () {};

        /// Warn method.
        static bool msg(  const std::string &f_message_str )
        {
            std::cout << "Msg of " <<  __FILE__ << " at line " << __LINE__ << ": " << f_message_str << std::endl;
            return true;
        }


        /// Warn method.
        static bool warn(  const std::string &f_message_str )
        {
            std::cout << "Warning in " <<  __FILE__ << " at line " << __LINE__ << ": " << f_message_str << std::endl;
            return true;
        }

        /// Error method.
        static bool error( const std::string &f_message_str )
        {
            std::cout << "Error in " <<  __FILE__ << " at line " << __LINE__ << ": " << f_message_str << std::endl;
            return true;
        }
        
        /// Exit error.
        static void exit( const std::string &f_message_str, 
                          const int f_exitCode_i = 1 )
        {
            std::cout << "Fatal error in " <<  __FILE__ << " at line " << __LINE__ << ": " << f_message_str << std::endl;
            std::cout << "Exiting with error code " <<  f_exitCode_i << std::endl;
            //exit(f_exitCode_i);
        }
    };
    
    typedef CLogger logger;
    
} // Namespace VIC

#endif // __LOGGER_H

/* ////////////  Version History ///////////////
 *  $Log: logger.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
