#ifndef __LINELIST_H
#define __LINELIST_H

/**
 *******************************************************************************
 *
 * @file lineList.h
 *
 * \class CLineList
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Handles a list of lines for displaying in screen or writing in file.
 *
 * The class is derived from CDrawingElementList implementing a list of lines.
 * Lines are composed of: 
 *  - rows and columns of the two points defining the line,
 *  - a color, and
 *  - a line width.
 *
 *******************************************************************************/

/* INCLUDES */
#include "drawingElementList.h"
#include "colors.h"

#include <vector>

/* CONSTANTS */


namespace VIC
{
    class CLineList: public CDrawingElementList
    {
    /// Constructor, Destructor
    public:
        /// Constructor
        CLineList( int f_bufferSize_i = -1);

        /// Destructor.
        virtual ~CLineList();

    /// Operations.
    public:

        // Add drawing lines from other list.
        virtual bool add (  const CLineList & f_otherList );

        // Draw all lines.
        virtual bool add (  float   f_u1_f, 
                            float   f_v1_f,
                            float   f_u2_f,
                            float   f_v2_f,
                            SRgba   f_color,
                            float   f_lineWidth_i );

        // Is blendable.
        virtual bool isBlendable () { return true; }

        // Clear all lines.
        virtual bool clear ();

        // Draw all lines.
        virtual bool show () const;

        // Write line in a SVG file.
        virtual bool write ( FILE*                f_file_p,
                             const float          f_offsetU_f = 0.0,
                             const float          f_offsetV_f = 0.0,
                             const std::string    f_parameters_str = "") const;

        // Return number of elements.
        virtual int  getSize () const;

    protected:
        typedef struct
        {
            /// Color information
            SRgba          color;

            /// Start position.
            float          u1_f, v1_f;

            /// End position.
            float          u2_f, v2_f;

            /// Line width
            float          lineWidth_f;

        } SLine;

    /// Private Members
    private:
        std::vector<SLine>    m_line_v;
    };
} // Namespace VIC


#endif // __LINELIST_H

/* ////////////  Version History ///////////////
 *  $Log: lineList.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
