#ifndef __IPPDEFS_H
#define __IPPDEFS_H

/**
 *******************************************************************************
 *
 * @file ippDefs.h
 *
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 *******************************************************************************/

/* INCLUDES */
#include "ipp.h"

#include <stdio.h>

/* CONSTANTS */

/* FUNCTIONS */

/* ******************************   METHOD   *********************************/
/** 
 * \brief       IPP Error-description print function
 * \author 	A. Buraschi (extracted and adapted from IPP documentation)
 * \date        -
 * \notes       -
 * \sa          -
 * \param 	ippStatus     (IN)    - IppFunctions result descriptor:
 *                                     Values >0, indicate Warning
 *                                     Values <0, indicate Error
 *                                     0 means noError.
 *                                     (for descriptions, see IPP reference
 *                                      manual n1, 'Error Reporting')
 *                                     
 * \return      (void)
 *
 *****************************************************************************/
inline 
void printIPPError(IppStatus ippStatus)
{
  if( ippStatus > ippStsNoErr )
    printf( "-- warning %d, %s\n", ippStatus, ippGetStatusString( ippStatus ));
  else if( ippStatus < ippStsNoErr )
    printf( "-- error %d, %s\n", ippStatus, ippGetStatusString( ippStatus ));
}


//void IPPLibInfo(void); // To show IPPLibs details

//void GetCPUInfo(void); // To show processor type.

//void GetCPUTime(void); // To show TimeStampCounter register current value.

#endif // __IPPDEFS_H

/* ////////////  Version History ///////////////
 *  $Log: ippDefs.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
