#ifndef __INTPARAMEDITOR_H
#define __INTPARAMEDITOR_H

/**
 *******************************************************************************
 *
 * @file intParamEditor.h
 *
 * \class CIntParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for  an object of type CIntParameter.
 *
 * The class implements a simple Qt editor with an input box where
 * the user enters an signed int value.
 *
 *******************************************************************************/

/* INCLUDES */
#include "baseParamEditorWidget.h"
#include "intParam.h"

/* PROTOTYPES */

namespace VIC
{
    /* PROTOTYPES */
    class CIntEditor;

    class CIntParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
    public:
        
        /// Constructors/Destructor
        CIntParameterEditor ( CIntParameter *  f_parameter_p,
                              QWidget        *  f_parent_p = NULL );

        virtual ~CIntParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

    /// Protected members
    protected:

        /// Stored value.
        CIntEditor *           m_qsb_p;

        /// Associated Int parameter
        CIntParameter *        m_parameter_p;
    };
}

#endif // __INTPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: intParamEditor.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
