#ifndef __INTPARAM_H
#define __INTPARAM_H

/**
 *******************************************************************************
 *
 * @file intParam.h
 *
 * \class CIntParameter
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Parameter interface for a signed int variable.
 *
 * The class implements a parameter interface for a signed int variable.
 *
 *******************************************************************************/

/* INCLUDES */
#include "parameter.h"

namespace VIC
{
    /* PROTOTYPES */

    class CIntParameter : public CParameter
    {
    public:
        
        /// Constructors/Destructor
        CIntParameter (  std::string                f_name_str = "",
                         std::string                f_comment_str = "",
                         int                        f_value_i = 0,
                         CParameterBaseConnector *  f_connector_p = NULL );

        virtual ~CIntParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set int value
        virtual int             getValue ( ) const;
        virtual bool            setValue ( int  f_value_b,
                                           bool f_shouldUpdate_b = true );


        /// Get editor.
        virtual QWidget *       createEditor ( );


    /// Protected members
    protected:

        /// Stored value.
        int                  m_val_i;
    };
}


#endif // __INTPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: intParam.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
