#ifndef __INT32IMAGE_H
#define __INT32IMAGE_H

/**
 *******************************************************************************
 *
 * @file intImage.h
 *
 * \class CIntImage
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Template class CTypedImage instantiated with <int>.
 *
 * The class is a type definition of CTypedImage<uint32_t>.
 *
 *******************************************************************************/

/* INCLUDES */
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<int32_t>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(int32_t) );
        setDataType( IDT_INT );
        setImageFormat( CImageBase::IF_LUMINANCE );
    }

    typedef CTypedImage<int32_t> CIntImage;
}



#endif // __INT32IMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: intImage.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
