#ifndef __INTEDITOR_H
#define __INTEDITOR_H

/**
 *******************************************************************************
 *
 * @file intEditor.h
 *
 * \class CIntEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CIntParameter.
 *
 * The class implements a simple Qt editor with one input box where
 * the user enters a signed integer value.
 *
 *******************************************************************************/

/* INCLUDES */
#include <QWidget>

/* PROTOTYPES */
class QLineEdit;

namespace VIC
{
    /* PROTOTYPES */

    class CIntEditor : public QWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        CIntEditor ( int     f_value_i,
                     QWidget *  f_parent_p = NULL );
        
        virtual ~CIntEditor ();

        int getValue() const { return m_value_i; }
        
        bool   setValue( int f_value_i );
        
        virtual QSize sizeHint () const;

    protected slots:
        void lineEditChanged();

    signals:
        void valueChanged( int );
        
        /// Protected members
    protected:

        /// Stored value.
        QLineEdit *          m_qle_p;

        /// Int value
        int                  m_value_i;
    };
}

#endif // __INTEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: intEditor.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
