#ifndef __INT2DPARAMEDITOR_H
#define __INT2DPARAMEDITOR_H

/**
 *******************************************************************************
 *
 * @file int2DParamEditor.h
 *
 * \class CInt2DParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CInt2DParameter.
 *
 * The class implements a simple Qt editor with two input boxes where
 * the user enters signed integer values.
 *
 *******************************************************************************/

/* INCLUDES */
#include "baseParamEditorWidget.h"

#include "int2DParam.h"

/* PROTOTYPES */

namespace VIC
{
    /* PROTOTYPES */
    class CIntEditor;

    class CInt2DParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        CInt2DParameterEditor ( CInt2DParameter *  f_parameter_p,
                                QWidget *          f_parent_p = NULL );

        virtual ~CInt2DParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

        /// Protected members
    protected:

        /// Stored value.
        CIntEditor *      m_qsb_p[2];

        /// Associated Int2D parameter
        CInt2DParameter * m_parameter_p;
    };
}

#endif // __INT2DPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: int2DParamEditor.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
