#ifndef __IMAGEPYRAMID_H
#define __IMAGEPYRAMID_H

/**
 *******************************************************************************
 *
 * @file imagePyramid.h
 *
 * \class CImagePyramid
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements a base tamplate class for handling image pyramid.
 *
 * The class implements an operator for handling image pyramids. The base
 * level of the pyramid (original image size) might be self allocated or
 * copied from the input source image.
 *
 *******************************************************************************/


/* CONSTANTS */

namespace VIC
{
    template <class ImgDType_>
    class CImagePyramid
    {
    /// Public data types.
    public:

    /// Constructors/Destructor
    public: 
        CImagePyramid ( );
        CImagePyramid ( unsigned int f_width_ui,
                        unsigned int f_height_ui,
                        unsigned int f_levels_ui,
                        bool         f_allocate0level_b = false );
        virtual ~CImagePyramid ( );

    /// Computation
    public:
        //bool computeGaussian ( const CTypedImage<ImgDType_> &f_img );

    /// Gets and Sets
    public:
        virtual 
        CTypedImage<ImgDType_> * getLevelImage ( unsigned int f_level_ui ) const;
        
        virtual 
        bool                     setLevels ( unsigned int f_levels_ui );

        virtual
        unsigned int             getLevels ( ) const;

        virtual 
        unsigned int             getWidth ( ) const;
        virtual 
        unsigned int             getHeight ( ) const;

        virtual 
        bool                     setImageSize ( unsigned int f_width_ui,
                                                unsigned int f_height_ui ); 

        virtual 
        bool                     setPyramidParams  ( unsigned int f_width_ui,
                                                     unsigned int f_height_ui,
                                                     unsigned int f_levels_ui );

        virtual 
        bool                     is0LevelAllocated ( ) const;

        virtual 
        void                     setAllocated0Level ( bool f_allocate_b );

    /// Protected help methods.
    protected:
        bool        createBuffers ( unsigned int f_levels_ui  );
        void        destroyBuffers ();
        
    /// Protected members.
    protected:

        /// Pyramid Images
        CTypedImage<ImgDType_> **      m_images_p;

        /// Levels of the pyramid.
        unsigned int                   m_levels_ui;

        /// Width of the original level image.
        unsigned int                   m_width_ui;

        /// Heightr of the original level image.
        unsigned int                   m_height_ui;

        /// Internal Buffer
        unsigned char *                m_buffer_p;

        /// Allocate level 0?
        bool                           m_alloc0level_b;
        
    };

    #include "imagePyramid_inline.h"
}



#endif // __IMAGEPYRAMID_H

/* ////////////  Version History ///////////////
 *  $Log: imagePyramid.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
