/*@@@**************************************************************************
 ** \file  imageConversion_inline.h
 * \date   Thu Aug 13 16:50:50 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
*****          (C) COPYRIGHT Hernan Badino - All Rights Reserved          *****
******************************************************************************/

/* INCLUDES */
#if defined ( _OPENMP )
 #include <omp.h>
#endif

/* CONSTANTS */
template <class _SrcType, class _TgtType >
bool
CImageConversion::convert ( const CTypedImage<_SrcType> &f_srcImg,
                            CTypedImage<_TgtType>       &fr_tgtImg )
{
    unsigned int wTgt_ui = fr_tgtImg.getWidth();
    unsigned int wSrc_ui = f_srcImg.getWidth();

    int h_i = f_srcImg.getHeight();

    /// Check for size.
    if ((int)fr_tgtImg.getHeight() < h_i  ||
        wTgt_ui < wSrc_ui ) 
        return false;
    
#if defined ( _OPENMP )
    const unsigned int numThreads_ui = omp_get_max_threads();
#pragma omp parallel for num_threads(numThreads_ui) schedule(dynamic)
#endif
    for (int i = 0 ; i < h_i; ++i)
    {
        const _SrcType *       scanLineSrc_p    = f_srcImg.getScanline (i);
        const _SrcType * const endScanLineSrc_p = scanLineSrc_p + wSrc_ui;
        _TgtType *             scanLineTgt_p    = fr_tgtImg.getScanline (i);

        for (; scanLineSrc_p < endScanLineSrc_p; ++scanLineSrc_p, ++scanLineTgt_p)
        {
            *scanLineTgt_p = (_TgtType)*scanLineSrc_p;
        }
    }

    return true;
}


/* ////////////  Version History ///////////////
 *  $Log: imageConversion_inline.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
