#ifndef __IMAGECONVERSION_H
#define __IMAGECONVERSION_H

/**
 *******************************************************************************
 *
 * @file imageConversion.h
 *
 * \class CImageConversion
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Class for converting an image of one type in a different type.
 *
 * This class provides a single template static method for image conversion.
 *
 *******************************************************************************/

/* INCLUDES */


/* CONSTANTS */


namespace VIC
{
    class CImageConversion
    {
    /// Constructor/Destructor deactivated
    private:
        CImageConversion();
        ~CImageConversion();

    public:
        template <class _SrcType, class _TgtType >
        static bool convert ( const CTypedImage<_SrcType>  &f_srcImg,
                                    CTypedImage<_TgtType>  &fr_tgtImg );


    };
    
    #include "imageConversion_inline.h"
}

#endif // __IMAGECONVERSION_H

/* ////////////  Version History ///////////////
 *  $Log: imageConversion.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
