/**
 *******************************************************************************
 * @file glheader.h
 *
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Some definitions for using the opengl library.
 *
 ******************************************************************************/

#ifndef GLHEADER
#define GLHEADER 1


#ifdef WIN32
  #include <windows.h>
  #include <GL/gl.h>
#ifndef QTVISU  
  #include "glh/glh_extensions.h"
#endif  
#else
  #define __USE_GLX_SGIX_EXTENSION__
  #define GLX_GLXEXT_PROTOTYPES 1
  #define GL_GLEXT_PROTOTYPES   1
  //#define GLX_GLXEXT_LEGACY     1    //must be defined to use glXGetProcAdress

#include <GL/gl.h>
#include <GL/glext.h>

#endif


//#ifdef WIN32
//  PFNGLACTIVETEXTUREARBPROC   glActiveTextureARB   = (PFNGLACTIVETEXTUREARBPROC  ) wglGetProcAddress("glActiveTextureARB");
//  PFNGLMULTITEXCOORD3FARBPROC glMultiTexCoord3f    = (PFNGLMULTITEXCOORD3FARBPROC) wglGetProcAddress("glMultiTexCoord3f");
//  PFNGLMULTITEXCOORD2FARBPROC glMultiTexCoord2f    = (PFNGLMULTITEXCOORD2FARBPROC) wglGetProcAddress("glMultiTexCoord2f");
//#endif

#ifdef WIN32
  #include <GL/wglext.h>
#else
  #include <GL/glx.h>
//  #include <GL/glxext.h>
#endif
/*
#include <GL/glut.h>
#include <string.h>
#include <stdio.h>

inline bool ExtensionAvailable(char name[]){
  bool result = false;
  const char* str = (const char*)glGetString(GL_EXTENSIONS);
  if (str != NULL) {
    result = strstr(str,name) != NULL;
    // P.Paysan suggests mod. of const str - scary ....
    str = NULL;
  }
  return result;
}
*/
#endif

/* ////////////  Version History ///////////////
 *  $Log: glheader.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
