#ifndef __GLVIEWER_H
#define __GLVIEWER_H

/**
 *******************************************************************************
 *
 * @file glViewer.h
 *
 * \class CGLViewer
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Interface class for the QGLViewer.
 *
 ******************************************************************************/

/* INCLUDES */

#include "QGLViewer/qglviewer.h"
#include "ioObj.h"
#include "3DRowVector.h"
#include "3DVectorImage.h"
#include "uShortImage.h"
#include "colors.h"

namespace VIC
{
    class CGLViewer : public QGLViewer, public CIOObj
    {

    public:
        CGLViewer();

    public:

        /// Clear the list of drawings.
        void                   clear ();

        /// Add a 3D point.
        void                   addPoint ( const C3DVector & f_point,
                                          const SRgb      & f_color  = SRgb ( 255, 255, 255 ),
                                          const C3DVector & f_normal = C3DVector (0,0,0) );

        /// Add a 3D point.
        void                   add3DVectorImg4Mesh ( const C3DVectorImage * f_3dvImg_p,
                                                     const CUShortImage *   f_dispTexture_p,
                                                     const float            f_maxDist_f = 0.5,
                                                     const float            f_maxDisp_f = 5 );


        bool                   setBackgroundColor ( SRgb f_bgColor ) { m_bgColor = f_bgColor; return true; }
        SRgb                   getBackgroundColor (  ) const { return m_bgColor; }
        
        bool                   setPointSize ( float f_pointSize_f ) { m_pointSize_f = f_pointSize_f; return true; }
        float                  getPointSize (  ) const { return m_pointSize_f; }
        
        bool                   setLineWidth ( float f_lineWidth_f ) { m_lineWidth_f = f_lineWidth_f; return true; }
        float                  getLineWidth (  ) const { return m_lineWidth_f; }

    protected :
        /// Draw
        virtual void           preDraw();

        /// Draw
        virtual void           draw();

        /// Initialize
        virtual void           init();

        /// Help string for project.
        virtual QString        helpString() const;

        /// Post draw virtual method
        virtual void           postDraw();
        

    private:
        void                   drawMeshes();
        
    private:
    struct SMeshData
    {
        const C3DVectorImage *  vectorImg_p;
        const CUShortImage *    dispTexture_p;
        float                   maxDist_f;
        float                   maxInvDist_f;
        bool                    created_b;
        unsigned int            displayList_ui;
    };
    
        std::vector<SMeshData>     m_meshes;

        /// Vector of 3D points.
        std::vector<C3DVector>     m_points;

         /// Vector of 3D points.
        std::vector<SRgb>          m_colors;

       /// Vector of 3D points.
        std::vector<C3DVector>     m_normals;

        /// Background color.
        SRgb                       m_bgColor;

        /// Background color.
        float                      m_pointSize_f;

        /// Line width.
        float                      m_lineWidth_f;
    };
}


#endif // __GLVIEWER_H
 

/* ////////////  Version History ///////////////
 *  $Log: glViewer.h,v $
 *  Revision 1.3  2010/01/18 17:12:29  badino
 *  General updates and added new classes.
 *
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////


