#ifndef __GAUSSIANPYRAMID_H
#define __GAUSSIANPYRAMID_H

/**
 *******************************************************************************
 *
 * @file gaussianPyramid.h
 *
 * \class CGAussianPyramid
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Specialized image pyramid class for creating Gaussian pyramids.
 *
 * Specialized image pyramid class for creating Gaussian pyramids. The first
 * level of the pyramid is not allocated but assign to be equal to the original
 * input image.
 *
 ******************************************************************************/

/* INCLUDES */
#include "ippDefs.h"
#include "imagePyramid.h"

/* CONSTANTS */

namespace VIC
{
    template <class ImgDType_>
    class CGaussianPyramid: public CImagePyramid<ImgDType_>
    {
    /// Constructors/Destructor
    public: 
        CGaussianPyramid ( );

        CGaussianPyramid ( unsigned int f_width_ui,
                           unsigned int f_height_ui,
                           unsigned int f_levels_ui );

        virtual ~CGaussianPyramid ( );

        /// Computation
    public:
        bool    compute ( const CTypedImage<ImgDType_> &f_img );
        
    protected:
        IppDataType getDataType();
        bool        computeNextLevel ( const CTypedImage<ImgDType_> * const f_src_p,
                                       CTypedImage<ImgDType_> * const       f_dst_p );

    private:
        /// Deactivate methods of parent class;
        void    setAllocated0Level ( bool f_allocate_b );
    };

    #include "gaussianPyramid_inline.h"

}

#endif // __GAUSSIANPYRAMID_H

/* ////////////  Version History ///////////////
 *  $Log: gaussianPyramid.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
